{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49 (0)351-8037944              =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/mmtools.html             =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 01.09.98 - 11:03:01 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, MMDSPObj, MMHook, MMDesign, MMACMDlg, MMACMCvt, MMObj, MMWavIn,
  MMSystem, MMWavOut;

type
  TForm1 = class(TForm)
    WaveIn: TMMWaveIn;
    ACMConverter: TMMACMConverter;
    ACM: TMMACM;
    MMDesigner1: TMMDesigner;
    DSPInterface1: TMMDSPInterface;
    Button1: TButton;
    Button2: TButton;
    Label1: TLabel;
    WaveOut: TMMWaveOut;
    Label2: TLabel;
    Label3: TLabel;
    DSPInterface2: TMMDSPInterface;
    Button3: TButton;
    Button4: TButton;
    Label4: TLabel;
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure DSPInterface1BufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
    procedure Button4Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure DSPInterface2BufferLoad(Sender: TObject; lpWaveHdr: PWaveHdr; var MoreBuffers: Boolean);
  private
  public
    BufferInCount: Longint;
    BufferOutCount: Longint;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{------------------------------------------------------------------------------}
procedure TForm1.Button2Click(Sender: TObject);
var
   Res: Boolean;
begin
   // the sender side
   BufferInCount := 0;

   Res := False;
   try
      Res := ACM.ChooseFormat(WaveIn.PWaveFormat,'');
   except
      // no exception here, the first call of ChooseFormat fails under Win98,
      // seems to be a bug in windows
   end;

   // first select the format
   if Res or ACM.ChooseFormat(WaveIn.PWaveFormat,'') then
   begin
      // now set the destination format for the converter
      ACMConverter.PWaveFormat := ACM.PWaveFormat;
      // and start sampling
      WaveIn.Start;
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.Button1Click(Sender: TObject);
begin
   WaveIn.Close;
end;

{------------------------------------------------------------------------------}
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   WaveIn.Close;
   WaveOut.Close;
end;

{------------------------------------------------------------------------------}
procedure TForm1.DSPInterface1BufferReady(Sender: TObject; lpWaveHdr: PWaveHdr);
begin
   // here can you copy the converted data and put it in your own structures or
   // send it out

   // lpWaveHdr^.lpData           - the buffer with data
   // lpWaveHdr^.dwBytesRecorded  - the recorded bytes in the buffer

   // You must copy the data because after the event returns the buffer will be re-used !


   inc(BufferInCount);
   Label1.Caption := IntToStr(BufferInCount);
end;

{------------------------------------------------------------------------------}
procedure TForm1.Button4Click(Sender: TObject);
begin
   // the receiver side:

   BufferOutCount := 0;

   // first set the format which will be played back
   // we use the selected input format here for simplification (select input first !)
   DSPInterface2.PWaveFormat := ACM.PWaveFormat;
   WaveOut.Start;
end;

{------------------------------------------------------------------------------}
procedure TForm1.Button3Click(Sender: TObject);
begin
   WaveOut.Close;
end;

{------------------------------------------------------------------------------}
procedure TForm1.DSPInterface2BufferLoad(Sender: TObject; lpWaveHdr: PWaveHdr; var MoreBuffers: Boolean);
begin
   // Params:
   // lpWaveHdr.lpData         : the buffer
   // lpWaveHdr.dwBufferLength : the required data bytes
   // lpWaveHdr.dwBytesRecorded: Return: number of bytes written to the buffer
   // MoreBuffers              : Return: set to True if you have more data

   { put your incomming data in the buffer }
   { if you have no data simply clear the buffer }

   // we simply clear the buffer in this demo
   FillChar(lpWaveHdr^.lpData^,lpWaveHdr^.dwBufferLength,0);

   // mark how many bytes you have written }
   lpWaveHdr^.dwBytesRecorded := lpWaveHdr^.dwBufferLength;

   // set to True if you have more data to play }
   MoreBuffers := True;

   inc(BufferOutCount);
   Label4.Caption := IntToStr(BufferOutCount);
end;
                        
end.
